<?php
// Complex test of sharing props between embedded & topmost docs.
// Also tests how {{TOCC}} recognizes headings.

// PHP strangely recognizes some classes but not the others (and even not always) even if
// they're defined after  code being executed. so ALWYAS DEFINE CLASSES PRIOR TO EXECUTING
// ANY CODE! I've spent some time trying to figure out why it didn't work the moment ago
// but does now even though all I did was resave the file with "echo 1;" added to its end.
class UtitPager extends UWikiPagerStub {
  function ReadPage($file, $format = null) { return $GLOBALS['titIncludes'][$file]; }
}

class Utitdynamic_Root extends Upre_Root {
  function IsDynamic($format, $params) { return true; }
}


  $GLOBALS['titIncludes'] = array('doc1' => '
==sub title==
%%(titDynamic)
sub dynamic 1 works
%%
~~~~~
{{Include: sub}}
---
%%(titDynamic)
sub dynamic 2 works
%%
===sub section===',
                                  'sub' => '
==subsub title==
%%(titDynamic)
subsub dynamic works
%%',
                                  'doc2' => '====doc2 subsection====',
                                  'doc3' => '===doc3 section===',
                                  'doc w/o headings' => 'some text');

  $src = '
==doc title==
{{Include: doc1}}
{{Include doc2}}
===doc section 1===
{{TOC}}
===doc section 2===
{{Include doc3}}
======wrong for include======
{{Include doc w/o headings}}
=======doesn\'t matter for include======
';

  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->LoadMarkup('wacko');
  $doc->settings->pager = new UtitPager;
  $doc->Parse();
  $html = $doc->ToHTML();

  $testFor = array(
    '<h1>\ndoc title<a name="doc_title" href="#doc_title" title="#doc_title" class="anchor">¶</a>\n</h1>',
    // test if header correction was ok:
    '<h2>\nsub title<a name="sub_title" href="#sub_title" title="#sub_title" class="anchor">¶</a>\n</h2>',

      '<pre>sub dynamic 1 works</pre>',
      '<hr class="curvy" />',

    // further embedding (doc -> doc1 -> sub here) must be corrected - for 'wacko'.
    // For other markups it won't happen due to current limitations (formats of
    // included doc run before outer Included does correction).
    '<h3>\nsubsub title<a name="subsub" href="#subsub" title="#subsub" class="anchor">¶</a>\n</h3>',
    // dynamic (render-time) phase should happen for included docs as well:
    '<pre>subsub dynamic works</pre>',
    '<hr class="thin" />',
    '<pre>sub dynamic 2 works</pre>',

      '<h3>\nsub section<a name="sub_section" href="#sub_section" title="#sub_section" class="anchor">¶</a>\n</h3>',
      '<h4>\ndoc2 subsection<a name="doc2_subsection" href="#doc2_subsection" title="#doc2_subsection" class="anchor">¶</a>\n</h4>',

    // back to our original doc:
    '<h2>\ndoc section 1<a name="doc_section_1" href="#doc_section_1" title="#doc_section_1" class="anchor">¶</a>\n</h2>',

    // {{TOC}}:
    '<legend>\ndoc title\n</legend>',
    '1.', 'sub title', '1.1.', 'subsub title', '1.2.', 'sub section',
    '1.2.1.', 'doc2 subsection', '2.', 'doc section 1', '3.', 'doc section 2',
    // Heading of wrongly structured included doc might be present, it's fine:
    '3.1.1.', 'doc3 section', '3.1.1.1.1.', 'doesn\'t matter',

    // our doc continues:
    '<h2>\ndoc section 2<a name="doc_section_2" href="#doc_section_2" title="#doc_section_2" class="anchor">¶</a>\n</h2>',
    // checking reaction on wrong heading structure. Topmost embedded heading is
    // "'===doc3 section===" (level 2) + 2 levels since {{Include doc3}} was sinside
    // "===doc section 2===" (level 2).
    'However, topmost embedded heading had level 4 while heading following {{Include}} was of level 5',
    'doc3 section' => false,  // must not be present, rather replaced with a message above.
    // finally:
    'some text', '<h6>\ndoesn\'t matter'
);

  $prevPos = 0;
  foreach ($testFor as $substr => $doExpect) {
    if (is_int($substr)) {
      $substr = $doExpect;
      $doExpect = true;
    }

    $pos = strpos($html, stripcslashes($substr), $prevPos);

    if ($doExpect) {
      TestThat($pos >= $prevPos);
      $prevPos = $pos;
    } else {
      TestThat($pos === false);
    }
  }
